# transcribe_youtube.py
import sys
import argparse

# Инициализация сервисов
from services.youtube_service import YoutubeService
from services.openai_service import OpenAIService

youtube_service = YoutubeService()
openai_service = OpenAIService()


def main():
    # Парсинг аргументов командной строки
    parser = argparse.ArgumentParser(description='Транскрибация YouTube видео')
    parser.add_argument('url', help='URL YouTube видео')
    parser.add_argument('-o', '--output', default='files/transcription.txt',
                        help='Путь к выходному файлу (по умолчанию: transcription.txt)')

    args = parser.parse_args()

    try:

        print(f"Загрузка аудио из видео: {args.url}")
        audio_path = youtube_service.download_audio_from_video(args.url)

        print("Транскрибация аудио...")
        transcription = openai_service.transcribe_audio(audio_path)

        print("Обработка текста...")
        processed_text = openai_service.process_text(transcription, '''
        ВАЖНО: Ответ должен быть только в формате HTML без CSS стилей!

Твоя задача:
1. Исправить синтаксические ошибки в тексте
2. Разбить по абзацам (2-3 предложения в абзаце)
3. Добавить заголовки уровня h2 (для небольших текстов - около 2 заголовков)
4. Убрать слова-паразиты и лишние предлоги
5. Сделать фразы более читаемыми

Примеры улучшений:
- "То есть, например, вот у нас пришла выдача" → "Например, у нас пришла выдача"

ФОРМАТ ОТВЕТА: Только HTML-разметка содержимого body без тегов body, head, html и без CSS стилей.

Пример ответа:
<h2>Заголовок раздела</h2>
<p>Первый абзац с исправленным текстом.</p>
<p>Второй абзац продолжает тему.</p>''')

        # Сохранение результата в файл
        with open(args.output, 'w', encoding='utf-8') as f:
            f.write(processed_text)

        print(f"Транскрибация завершена. Результат сохранен в: files/{args.output}")

    except Exception as e:
        print(f"Ошибка: {str(e)}")
        sys.exit(1)


if __name__ == "__main__":
    main()