# services/youtube_service.py
from pytubefix import YouTube
from pytubefix.cli import on_progress
import os
import subprocess


class YoutubeService:
    def __init__(self):
        pass

    def download_audio_from_video(self, url):
        try:
            video = YouTube(url, on_progress_callback=on_progress)

            audio_stream = video.streams. \
                filter(mime_type='audio/mp4'). \
                order_by('filesize'). \
                desc().first()

            # Используем фиксированное имя файла
            output_file = 'files/audio.mp3'

            # Создаем директорию files если её нет
            os.makedirs('files', exist_ok=True)

            audio_stream.download(output_path='files')
            audio_file_path = f'files/{audio_stream.default_filename}'

            # Используем subprocess вместо os.system для лучшего контроля
            result = subprocess.run([
                'ffmpeg', '-i', audio_file_path,
                '-vn', '-ab', '128k', '-ar', '44100',
                '-y', output_file
            ], capture_output=True, text=True)

            if result.returncode != 0:
                raise SystemError(f"Ошибка при конвертации аудио: {result.stderr}")

            # Удаляем промежуточный аудио файл
            if os.path.exists(audio_file_path):
                os.remove(audio_file_path)

            return output_file

        except Exception as e:
            print(f"Произошла ошибка: {str(e)}")
            raise e