# YouTube Transcriber

Скрипт для автоматической транскрибации YouTube видео с использованием OpenAI Whisper API и последующей обработкой текста через GPT-4.

## Возможности

- Загрузка аудио из YouTube видео
- Транскрибация аудио в текст через OpenAI Whisper
- Автоматическая обработка текста:
  - Исправление синтаксических ошибок
  - Удаление слов-паразитов
  - Форматирование в HTML с заголовками и абзацами
  - Улучшение читаемости текста

## Требования

- Python 3.8+
- FFmpeg (для конвертации аудио)
- OpenAI API ключ

## Установка

1. Клонируйте репозиторий или скачайте файлы скрипта

2. Установите зависимости:
```bash
pip install -r requirements.txt
```

3. Установите FFmpeg:
```bash
# Ubuntu/Debian
sudo apt update
sudo apt install ffmpeg

# macOS
brew install ffmpeg

# Windows
# Скачайте с https://ffmpeg.org/download.html
```

4. Создайте файл `.env` в корневой директории проекта и добавьте ваш OpenAI API ключ:
```
OPENAI_API_KEY=your_api_key_here
```

## Использование

### Базовое использование

```bash
python transcribe_youtube.py "https://www.youtube.com/watch?v=VIDEO_ID"
```

По умолчанию результат сохранится в `files/transcription.txt`

### Указание выходного файла

```bash
python transcribe_youtube.py "https://www.youtube.com/watch?v=VIDEO_ID" -o output.txt
```

или

```bash
python transcribe_youtube.py "https://www.youtube.com/watch?v=VIDEO_ID" --output output.txt
```

## Структура проекта

```
.
├── transcribe_youtube.py      # Основной скрипт
├── services/
│   ├── youtube_service.py     # Сервис для работы с YouTube
│   └── openai_service.py      # Сервис для работы с OpenAI API
├── files/                     # Директория для временных и выходных файлов
├── requirements.txt           # Зависимости Python
└── .env                      # Файл с переменными окружения (создать самостоятельно)
```

## Как это работает

1. **Загрузка аудио**: Скрипт загружает аудиодорожку из YouTube видео и конвертирует её в MP3 формат
2. **Транскрибация**: Аудио отправляется в OpenAI Whisper API для преобразования в текст
3. **Обработка текста**: Полученный текст обрабатывается через GPT-4 для улучшения качества
4. **Сохранение**: Обработанный текст сохраняется в HTML формате

## Примеры результата

Исходный текст:
```
То есть, например, вот у нас пришла выдача и мы должны ее как-то обработать...
```

Обработанный текст:
```html
<h2>Обработка выдачи</h2>
<p>Например, у нас пришла выдача и мы должны ее обработать.</p>
```

## Возможные проблемы

1. **Ошибка "OPENAI_API_KEY не найден"**: Убедитесь, что создали файл `.env` с ключом API
2. **Ошибка при конвертации аудио**: Проверьте, что FFmpeg установлен корректно
3. **Ошибка загрузки видео**: Проверьте URL и доступность видео

## Лимиты и стоимость

- Whisper API: ~$0.006 за минуту аудио
- GPT-4: зависит от длины текста (примерно $0.01-0.03 за обработку стандартного видео)