## Audio Transcription with OpenAI Whisper

Скрипт для автоматической транскрибации аудиофайлов в текст с использованием OpenAI Whisper API.

## Возможности

- Транскрибация аудиофайлов в текстовый формат
- Поддержка различных аудиоформатов (mp3, mp4, wav, m4a, webm)
- Автоматическое определение языка
- Сохранение результата в текстовый файл

## Требования

- Python 3.7+
- OpenAI API ключ
- Аудиофайл размером до 25 MB

## Установка

1. Клонируйте репозиторий или скачайте файл `main.py`

2. Установите зависимости:
```bash
pip install openai python-dotenv
```

3. Создайте файл `.env` в корневой директории проекта:
```
OPENAI_API_KEY=ваш_api_ключ_здесь
```

## Использование

1. Поместите аудиофайл `audio.mp3` в ту же директорию, что и скрипт

2. Запустите скрипт:
```bash
python main.py
```

3. Результат будет сохранен в файл `transcription.txt`

## Структура проекта

```
.
├── main.py              # Основной скрипт
├── .env                 # Файл с API ключом (не коммитить!)
├── audio.mp3            # Входной аудиофайл
├── transcription.txt    # Выходной файл с транскрипцией
└── README.md           # Этот файл
```

## Настройки

Вы можете изменить следующие параметры в `main.py`:

- **Имя входного файла**: измените `audio_path = "audio.mp3"` на нужное
- **Имя выходного файла**: измените `output_path = "transcription.txt"`
- **Формат вывода**: измените `response_format="text"` на:
  - `"json"` - для получения детальной информации с временными метками
  - `"srt"` - для субтитров в формате SRT
  - `"vtt"` - для субтитров в формате WebVTT

## Ограничения

- Максимальный размер файла: 25 MB
- Поддерживаемые форматы: mp3, mp4, mpeg, mpga, m4a, wav, webm
- Стоимость: Примерно, $0.006 за минуту аудио

## Получение API ключа

1. Зарегистрируйтесь на [platform.openai.com](https://platform.openai.com)
2. Перейдите в раздел API Keys
3. Создайте новый ключ и скопируйте его
4. Добавьте ключ в файл `.env`

## Безопасность

- **НЕ коммитьте** файл `.env` в репозиторий
- Добавьте `.env` в `.gitignore`
- Храните API ключ в безопасном месте

## Пример вывода

```
Транскрибация файла: audio.mp3
Транскрипция успешно сохранена в: transcription.txt

Предпросмотр транскрипции:
Здравствуйте, это пример транскрибированного текста...
```

## Решение проблем

**Ошибка: OPENAI_API_KEY не найден**
- Убедитесь, что файл `.env` существует и содержит правильный ключ

**Ошибка: Файл audio.mp3 не найден**
- Проверьте, что аудиофайл находится в той же директории, что и скрипт

**Ошибка при транскрибации**
- Проверьте баланс вашего OpenAI аккаунта
- Убедитесь, что размер файла не превышает 25 MB
- Проверьте формат аудиофайла